const nodemailer = require('nodemailer');

const transporter = nodemailer.createTransport({
  service: process.env.EMAIL_SERVICE || 'gmail', // e.g., 'gmail'
  auth: {
    user: process.env.EMAIL_USER,
    pass: process.env.EMAIL_PASS,
  },
});

const sendSubmissionNotification = async (eventTitle, participantData) => {
  if (!process.env.EMAIL_USER || !process.env.EMAIL_PASS) {
    console.log('Email credentials not found. Skipping email notification.');
    console.log(`[Mock Email] To: Admin, Subject: New Submission for ${eventTitle}, Body: ${JSON.stringify(participantData)}`);
    return;
  }

  const mailOptions = {
    from: process.env.EMAIL_USER,
    to: process.env.ADMIN_EMAIL || process.env.EMAIL_USER,
    subject: `New Submission: ${eventTitle}`,
    html: `
      <h2>New Registration for ${eventTitle}</h2>
      <p><strong>Name:</strong> ${participantData.name}</p>
      <p><strong>Email:</strong> ${participantData.email}</p>
      <p><strong>Phone:</strong> ${participantData.phone || 'N/A'}</p>
      <p><strong>Organization:</strong> ${participantData.organization || 'N/A'}</p>
      <br/>
      <p>Check the dashboard for more details.</p>
    `,
  };

  try {
    await transporter.sendMail(mailOptions);
    console.log('Notification email sent successfully');
  } catch (error) {
    console.error('Error sending email:', error);
  }
};

module.exports = { sendSubmissionNotification };
