const https = require('https');

const url = 'https://aeer-ua.com.ufm-madagascar.org/api/events';
const options = {
  headers: {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
  }
};

https.get(url, options, (res) => {
  let data = '';

  res.on('data', (chunk) => {
    data += chunk;
  });

  res.on('end', () => {
    try {
      console.log('Response status:', res.statusCode);
      console.log('Response body:', data);
      const json = JSON.parse(data);
      console.log('Parsed JSON:', JSON.stringify(json, null, 2));
    } catch (e) {
      console.error('Error parsing JSON:', e);
    }
  });

}).on('error', (err) => {
  console.error('Error fetching URL:', err);
});
