const { pool } = require('../config/db');

const seedEvent = async () => {
  const client = await pool.connect();
  try {
    console.log('Seeding event...');
    
    const eventTitle = 'Innovation Énergétique & Numérique';
    const eventDescription = 'Le carrefour où la transition énergétique rencontre la révolution digitale. Rejoignez les leaders de demain pour façonner un avenir durable.';
    const eventDate = '2025-10-15 09:00:00+03';
    const eventLocation = 'Campus Universitaire, Antananarivo';
    
    // Check if event exists
    const checkRes = await client.query('SELECT id FROM events WHERE title = $1', [eventTitle]);
    
    if (checkRes.rows.length === 0) {
        // Get admin user id for created_by
        const adminRes = await client.query("SELECT id FROM users WHERE email = 'admin@aeer-ua.com'");
        let adminId = null;
        if (adminRes.rows.length > 0) {
            adminId = adminRes.rows[0].id;
        }

        await client.query(`
            INSERT INTO events (title, description, date, location, created_by, is_active)
            VALUES ($1, $2, $3, $4, $5, true)
        `, [eventTitle, eventDescription, eventDate, eventLocation, adminId]);
        console.log(`Event "${eventTitle}" created successfully.`);
    } else {
        console.log(`Event "${eventTitle}" already exists.`);
    }

  } catch (e) {
    console.error('Error seeding event:', e);
  } finally {
    client.release();
    pool.end();
  }
};

seedEvent();
