const { pool } = require('../config/db');

const removePartnerRole = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');

    // Remove 'partner' role
    await client.query(`DELETE FROM roles WHERE name = 'partner'`);

    console.log("Role 'partner' removed successfully");
    await client.query('COMMIT');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Error removing partner role', e);
  } finally {
    client.release();
    pool.end();
  }
};

removePartnerRole();
