const { pool } = require('../config/db');

const addResetTokenColumns = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');

    await client.query(`
      ALTER TABLE users 
      ADD COLUMN IF NOT EXISTS reset_token VARCHAR(255),
      ADD COLUMN IF NOT EXISTS reset_token_expiry TIMESTAMP WITH TIME ZONE;
    `);

    await client.query('COMMIT');
    console.log('Added reset_token columns to users table');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Error adding columns', e);
  } finally {
    client.release();
    pool.end(); // Close the pool to exit the script
  }
};

addResetTokenColumns();
