const { pool } = require('../config/db');

const migrate = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');
    
    // Add is_active column to events table if it doesn't exist
    await client.query(`
      ALTER TABLE events 
      ADD COLUMN IF NOT EXISTS is_active BOOLEAN DEFAULT TRUE;
    `);

    await client.query('COMMIT');
    console.log('Migration successful: Added is_active to events table');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Migration failed', e);
  } finally {
    client.release();
    pool.end();
  }
};

migrate();
