const express = require('express');
const router = express.Router();
const { 
  getAllEvents, 
  getEventById, 
  createEvent, 
  updateEvent, 
  deleteEvent,
  registerForEvent,
  toggleEventStatus,
  getEventRegistrations,
  getAllRegistrations,
  updateRegistration,
  deleteRegistration
} = require('../controllers/eventController');
const { authenticateToken, authorizeRole } = require('../middleware/authMiddleware');

// Public routes
router.get('/', getAllEvents);
router.get('/:id', getEventById);
router.post('/:id/register', registerForEvent); // Now public

// Protected routes
// Admin routes
router.post('/', authenticateToken, authorizeRole(['admin']), createEvent);
router.put('/:id', authenticateToken, authorizeRole(['admin']), updateEvent);
router.delete('/:id', authenticateToken, authorizeRole(['admin']), deleteEvent);
router.patch('/:id/status', authenticateToken, authorizeRole(['admin']), toggleEventStatus);
router.get('/:id/registrations', authenticateToken, authorizeRole(['admin']), getEventRegistrations);

// New CRUD routes for registrations
router.get('/registrations/all', authenticateToken, authorizeRole(['admin']), getAllRegistrations);
router.put('/registrations/:id', authenticateToken, authorizeRole(['admin']), updateRegistration);
router.delete('/registrations/:id', authenticateToken, authorizeRole(['admin']), deleteRegistration);

module.exports = router;
