const express = require('express');
const router = express.Router();
const { register, login, getMe, logout, getAllUsers, changePassword, forgotPassword, resetPassword } = require('../controllers/authController');
const { authenticateToken, authorizeRole } = require('../middleware/authMiddleware');
const { body } = require('express-validator');

// Validation middleware could be added here
router.post('/register', register);
router.post('/login', login);
router.get('/me', authenticateToken, getMe);
router.post('/logout', logout);
router.get('/users', authenticateToken, authorizeRole(['admin']), getAllUsers);
router.post('/change-password', authenticateToken, changePassword);
router.post('/forgot-password', forgotPassword);
router.post('/reset-password', resetPassword);

module.exports = router;
